const CustomFieldView = require('./CustomFieldView');

/**
 * @class MultiselectCustomFieldView
 * @extends CustomFieldView
 *
 * @property {CustomFieldModel} model
 */
const MultiselectCustomFieldView = CustomFieldView.extend({

    template: require('./tpl/edit/MultiselectCustomFieldView.hbs'),

    ui: _.extend({}, CustomFieldView.prototype.ui, {
        input: '.check',
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    }),

    events: {
        'bemmy:set @ui.input': 'onChange'
    },

    initialize() {
        if (this.options.fieldViewMode === CustomFieldView.MODE.VIEW) {
            this.template = require('./tpl/view/StringCustomFieldView.hbs');
        }

        CustomFieldView.prototype.initialize.apply(this, arguments);
    },

    onRender() {
        this.ui.input.bemmyCheck();
        this.ui.popupOverlay.bemmyPopupOverlay();

        CustomFieldView.prototype.onRender.apply(this, arguments);
    },

    onChange() {
        const values = [];

        this.ui.input.filter('.checked').find('input').each((index, elt) => {
            values.push($(elt).attr('value'));
        });

        this.onValueChanged(values);
    },

    serializeData() {
        const serialized = CustomFieldView.prototype.serializeData.apply(this, arguments);

        if (_.isNull(serialized.value)) {
            serialized.value = [];
        }

        if (!_.isArray(serialized.value)) {
            serialized.value = [serialized.value];
        }

        return serialized;
    }

});

module.exports = MultiselectCustomFieldView;
