const CustomFieldView = require('./CustomFieldView');
const StringCustomFieldView = require('./StringCustomFieldView');

/**
 * @class SelectCustomFieldView
 * @extends StringCustomFieldView
 */
const RadioCustomFieldView = StringCustomFieldView.extend({

    template: require('./tpl/edit/RadioCustomFieldView.hbs'),

    ui: _.extend({}, StringCustomFieldView.prototype.ui, {
        input: '.check',
        nativeInput: 'input',
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    }),

    events: {
        'bemmy:set @ui.input': 'onChange'
    },

    initialize() {
        StringCustomFieldView.prototype.initialize.apply(this, arguments);

        if (this.options.fieldViewMode === CustomFieldView.MODE.VIEW) {
            this.template = require('./tpl/view/StringCustomFieldView.hbs');
        }
    },

    onRender() {
        this.ui.input.bemmyCheck();
        this.ui.popupOverlay.bemmyPopupOverlay();

        CustomFieldView.prototype.onRender.apply(this, arguments);
    },

    onChange(evtObj) {
        this.onValueChanged($(evtObj.currentTarget).find('input').val());
    }
});

module.exports = RadioCustomFieldView;
