const resources = require('../../../resources');
const CustomFieldView = require('./CustomFieldView');
const StringCustomFieldView = require('./StringCustomFieldView');
const TaskTypeAutocompleteView = require('../../controlSection/filter/selects/autocomplete/TaskTypeAutocompleteView');

/**
 * @class ResourceTypeCustomFieldView
 * @extends StringCustomFieldView
 */
const ResourceTypeCustomFieldView = StringCustomFieldView.extend({

    template: require('./tpl/edit/ResourceTypeCustomFieldView.hbs'),

    events: {},

    regions: {
        typeSelector: '.type_selector'
    },

    ui: _.extend({}, StringCustomFieldView.prototype.ui, {
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    }),

    initialize() {
        CustomFieldView.prototype.initialize.apply(this, arguments);

        if (this.options.fieldViewMode === CustomFieldView.MODE.VIEW) {
            this.template = require('./tpl/view/StringCustomFieldView.hbs');
        }
    },

    onRender() {
        this.ui.popupOverlay.bemmyPopupOverlay();

        if (this.options.fieldViewMode === CustomFieldView.MODE.EDIT) {
            const self = this;

            resources.resourceTypes().done(resourcesTypes => {
                self.typeSelector.close();
                self.typeSelector.show(new TaskTypeAutocompleteView({
                    lazy: 400,
                    model: self.model,
                    items: resourcesTypes,
                    value: self.model.get('value'),
                    placeHolder: 'Resource type',
                    showAnyItem: true,
                    modelTargetKey: 'value'
                }));
            });
        }
    },

    setTaskValue() {
        if (this.ui.popup.toggleClass) {
            this.ui.popup.toggleClass(this.options.tipVisibleClass, false);
        }
    }
});

module.exports = ResourceTypeCustomFieldView;
