const CustomFieldView = require('./CustomFieldView');
const StringCustomFieldView = require('./StringCustomFieldView');

/**
 * @class SelectCustomFieldView
 * @extends StringCustomFieldView
 *
 * @property {CustomFieldModel} model
 */
const SelectCustomFieldView = StringCustomFieldView.extend({

    template: require('./tpl/edit/SelectCustomFieldView.hbs'),

    ui: _.extend({}, StringCustomFieldView.prototype.ui, {
        input: '.select',
        nativeInput: 'select',
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    }),

    events: {
        'change @ui.nativeInput': 'onChange'
    },

    onRender() {
        this.ui.input.bemmySelect();
        this.ui.popupOverlay.bemmyPopupOverlay();

        CustomFieldView.prototype.onRender.apply(this, arguments);
    },

    serializeValues() {
        let serialized = [];
        const context = this.model.get('context') || {};
        const value = this.model.get('value');
        const isCurrentValueExists =
            value === null ||
            _.filter(((context && context.values) || []), item => item[1] === value).length > 0;

        if (context && !context.values) {
            context.values = { values: [['-- DEFAULT VALUE | looks smth went wrong --', '']] };
        }

        serialized = _.map(context.values, item => {
            return {
                title: item[0],
                value: item[1]
            };
        });

        if (!isCurrentValueExists) {
            serialized.unshift({
                title: value,
                value
            });
        }

        if (!this.model.get('required')) {
            _.union(serialized, {
                title: 'Any',
                value: ''
            });
        }

        return serialized;
    }
});

module.exports = SelectCustomFieldView;
