const BasicCollection = require('../../../collection/BasicCollection');
const SelectTaskResourceGridView = require('../selectResourceGrid/SelectTaskResourceGridView');

/**
 * @class SelectResourceGridView
 * @extends Backbone.Marionette.Layout
 *
 * @property {CustomFieldModel} model
 */
const SelectResourceGridView = Marionette.Layout.extend({

    className: 'modal__t task_resource_select',
    template: require('./tpl/edit/SelectResourceGrid.hbs'),

    collectionEvents: {
        sync: 'render'
    },

    onRender() {
        const customFieldContext = this.model.get('context');

        this.subTable.close();
        this.subTable.show(new SelectTaskResourceGridView({
            model: new Backbone.Model({}),
            sortType: BasicCollection.SORT_TYPE.SERVER,
            sortable: false,
            className: '',
            isModal: this.options.isModal,
            isMultiple: Boolean(customFieldContext && customFieldContext.multiple),
            collection: this.collection,
            selectable: true
        }));

        this.$('.popup-overlay').bemmyPopupOverlay();
    }
});

module.exports = SelectResourceGridView;
