/* eslint camelcase: 0 */
const SelectResourceGridView = require('./SelectResourceGridView');
const SelectResourceFilterView = require('./SelectResourceFilterView');
const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');
// eslint-disable-next-line no-unused-vars
const ResourceFilterModel = require('../../../model/filter/ResourceFilterModel');
const PaginatorView = require('../../pagination/paging/PaginatorView');

/**
 * @class SelectResourceModalView
 * @extends BasicConfirmDialogView
 *
 * @property {CustomFieldModel} model
 * @property {TaskResourcesCollection} collection
 * @property {Marionette.Region} grid
 * @property {Marionette.Region} filter
 * @property {Marionette.Region} pagination
 */
const SelectResourceModalView = BasicConfirmDialogView.extend({

    template: require('./tpl/edit/SelectResourceModalView.hbs'),

    collectionEvents: {
        customFieldResourceSelected: 'onResourceSelected'
    },

    onRender() {
        this.filter.close();
        this.grid.close();
        this.pagination.close();

        this.filter.show(this.getResourceFilter());
        this.grid.show(this.getResourceGrid());
        this.pagination.show(this.getPagination());

        const self = this;

        setTimeout(() => {
            self.updateModalHeight();
            self.collection.trigger('update:complete');
        }, 0);
    },

    onApprove() {
        this.onResourceSelected(this.collection.getSelected());
    },

    getResourceGrid() {
        return new SelectResourceGridView({
            isModal: true,
            model: this.model,
            collection: this.collection
        });
    },

    getResourceFilter() {
        return new SelectResourceFilterView({
            model: this.collection.getFilterParams(),
            taskProps: this.options.taskProps,
            collection: this.collection
        });
    },

    getPagination() {
        return new PaginatorView({
            collection: this.collection,
            gridCnt: null
        });
    },

    onResourceSelected(resources) {
        /* eslint complexity: [1, 9] */

        let value = String(this.model.get('value')) || '';
        const context = this.model.get('context');
        const descriptions = this.model.get('resource_description') || {};
        const links = this.model.get('resource_links') || {};

        value = (value ? value.split(',') : []);

        if (!_.isArray(resources)) {
            resources = [resources];
        }

        resources.forEach(resource => {
            const id = String(resource.get('id'));

            value.push(id);
            descriptions[id] = resource.get('description');
            links[id] = resource.get('http');
        });

        // Only resource ID last from selected list will be set as value
        // for fields that do NOT allow multiple values
        this.model.set({
            value: (
                context && context.multiple ?
                    value.join(',') :
                    (value.length ? String(value.pop()) : '')
            ),
            resource_description: descriptions,
            resource_links: links
        });

        this.close();
    },

    updateModalHeight() {
        const selfHeight = this.$el.outerHeight();
        const filterHeight = this.filter.currentView.$el.outerHeight();

        this.grid.currentView.$el.css(
            'height',
            (selfHeight - SelectResourceModalView.CONTROLS_HEIGHT - filterHeight)
        );
    }
}, {
    CONTROLS_HEIGHT: 200
});

module.exports = SelectResourceModalView;
