const CustomFieldView = require('./CustomFieldView');
const AuthorSuggestView = require('../../controlSection/filter/suggest/AuthorSuggestView');

const StaffCustomFieldView = CustomFieldView.extend({

    template: require('./tpl/edit/StaffCustomFieldView.hbs'),

    ui: _.extend({}, CustomFieldView.prototype.ui, {
        input: '.input',
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    }),

    initialize() {
        CustomFieldView.prototype.initialize.apply(this, arguments);

        if (this.options.fieldViewMode === CustomFieldView.MODE.VIEW) {
            this.template = require('./tpl/view/StaffCustomFieldView.hbs');
        }
    },

    onRender() {
        this.addRegions({ authorSuggest: '#authorSuggest' });

        CustomFieldView.prototype.onToggle.call(this, this.options.isVisible);

        this.authorSuggest.close();
        this.authorSuggest.show(new AuthorSuggestView({
            model: this.model,
            defaultValue: this.model.get('value'),
            modelTargetKey: 'value',
            placeholder: this.model.get('title')
        }));
    }
});

module.exports = StaffCustomFieldView;
