const CustomFieldView = require('./CustomFieldView');

const StringCustomFieldView = CustomFieldView.extend({

    template: require('./tpl/edit/StringCustomFieldView.hbs'),

    ui: _.extend({}, CustomFieldView.prototype.ui, {
        input: '.input',
        nativeInput: '.input__input',
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    }),

    events: {
        'bemmy:refresh @ui.input': 'onChange'
    },

    initialize() {
        CustomFieldView.prototype.initialize.apply(this, arguments);

        if (this.options.fieldViewMode === CustomFieldView.MODE.VIEW) {
            this.template = require('./tpl/view/StringCustomFieldView.hbs');
        }

        this.onChange = _.debounce(this.onChange, 0).bind(this);
    },

    onRender() {
        this.ui.input.bemmyInput();
        this.ui.popupOverlay.bemmyPopupOverlay();

        CustomFieldView.prototype.onToggle.call(this, this.options.isVisible);
    },

    onChange() {
        if (this.ui.nativeInput && this.ui.nativeInput.val) {
            this.onValueChanged(this.ui.nativeInput.val());
        }
    },

    serializeData() {
        const serialized = CustomFieldView.prototype.serializeData.apply(this, arguments);

        if (serialized &&
            serialized.value instanceof Array &&
            this.options.fieldViewMode === CustomFieldView.MODE.VIEW) {
            serialized.value = serialized.value.join(', ');
        }

        return serialized;
    }
});

module.exports = StringCustomFieldView;
