const CustomFieldView = require('./CustomFieldView');
const StringCustomFieldView = require('./StringCustomFieldView');
const suggestMixin = require('../../mixin/suggestMixin');

/**
 * @class SuggestCustomFieldView
 * @extends StringCustomFieldView
 *
 * @property {CustomFieldModel} model
 */
const SuggestCustomFieldView = StringCustomFieldView.mixin(suggestMixin).extend({

    template: require('./tpl/edit/SuggestCustomFieldView.hbs'),

    onRender() {
        this.$('.popup-overlay').bemmyPopupOverlay();

        CustomFieldView.prototype.onRender.apply(this, arguments);
    },

    serializeValues() {
        const context = _.extend({}, this.model.get('context'));

        if (context && !context.values) {
            context.values = { values: [['-- DEFAULT VALUE | looks smth went wrong --', '']] };
        }

        return context.values;
    },

    serializeData() {
        const serialized = CustomFieldView.prototype.serializeData.apply(this, arguments);

        return Object.assign(serialized, {
            title: this.model.get('title'),
            lazy: 30,
            model: this.model,
            items: this.serializeValues(),
            value: this._getKeyValueOf(this.model.get('value'), 'key'),
            placeHolder: '',
            showAnyItem: !this.model.get('required'),
            modelTargetKey: 'value'
        });
    }
});

module.exports = SuggestCustomFieldView;
