const CustomFieldView = require('./CustomFieldView');
const StringCustomFieldView = require('./StringCustomFieldView');

const TextCustomFieldView = StringCustomFieldView.extend({

    template: require('./tpl/edit/TextCustomFieldView.hbs'),

    ui: _.extend({}, StringCustomFieldView.prototype.ui, {
        input: '.textarea',
        nativeInput: '.textarea__textarea',
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    }),

    events: _.extend({}, StringCustomFieldView.prototype.events, {
        'bemmy:refresh @ui.input': 'onChange'
    }),

    onRender() {
        CustomFieldView.prototype.onToggle.call(this, this.options.isVisible);
        this.ui.input.bemmyTextarea();
        this.ui.popupOverlay.bemmyPopupOverlay();
        this.ui.nativeInput.val(this.model.get('value'));
    }
});

module.exports = TextCustomFieldView;
