(function () {
    const app = require('../../../app');
    const CustomFieldView = require('./CustomFieldView');
    const CustomFieldModel = require('../../../model/CustomFieldModel');

    /**
     * @class UniqueCustomFieldView
     * @extends CustomFieldView
     */
    const UniqueCustomFieldView = CustomFieldView.extend({

        template: require('./tpl/edit/UniqueCustomFieldView.hbs'),

        controlHtml: '',
        isBrokenTemplate: false,

        initialize() {
            CustomFieldView.prototype.initialize.apply(this, arguments);
            this.createControl();
        },

        createControl() {
            const helperManager = app.getHelperManager();
            const helper = helperManager.getEditHelper(this.model.get(CustomFieldModel.EDIT_HELPER_NAME));
            const self = this;

            if (typeof helper === 'function') {
                helper(this.model.toJSON()).done(controlHtml => {
                    self.controlHtml = controlHtml;
                    self.render();
                });
            }
        },

        serializeData() {
            const serialized = CustomFieldView.prototype.serializeData.apply(this, arguments);

            serialized.controlHtml = this.controlHtml;
            serialized.isBrokenTemplate = this.isBrokenTemplate;

            return serialized;
        }
    });

    module.exports = UniqueCustomFieldView;
})();
