// eslint-disable-next-line no-unused-vars
const app = require('../../../../app');
const FilterLayout = require('../../../controlSection/filter/FilterLayout');

/**
 * @class SelectTaskFilterView
 * @extends FilterLayout
 *
 * @property {FilterModel} model
 */
const SelectTaskFilterView = FilterLayout.extend({

    className() {
        return ('modal__filter ' + FilterLayout.prototype.className);
    },

    onFilterTrigger(evtObj) {
        if (evtObj) {
            evtObj.preventDefault();
        }

        const filterValues = this.model.clone();

        this.ui.filterTrigger.removeClass(this.options.triggerActiveClass);
        app.trigger('change:filterparams:preset', filterValues);
    }
});

module.exports = SelectTaskFilterView;
