const BasicCollection = require('../../../../collection/BasicCollection');
const TasksGridView = require('../../../tasks/tasksGridCompact/grid/TasksCompactGridView');

/**
 * @class SelectTaskGridView
 * @extends Backbone.Marionette.Layout
 *
 * @property {Marionette.Region} subTable
 */
const SelectTaskGridView = Marionette.Layout.extend({

    className: 'modal__t task_resource_select',
    template: require('./tpl/edit/SelectTaskGrid.hbs'),

    collectionEvents: {
        sync: 'render'
    },

    onRender() {
        const customFieldContext = this.model.get('context');

        this.subTable.close();
        this.subTable.show(new TasksGridView({
            isModal: true,
            model: new Backbone.Model({}),
            editable: false,
            sortType: BasicCollection.SORT_TYPE.SERVER,
            sortable: false,
            className: '',
            collection: this.collection,
            isMultiple: Boolean(customFieldContext && customFieldContext.multiple),
            selectable: true
        }));
    }
});

module.exports = SelectTaskGridView;
