const SelectResourceModalView = require('../SelectResourceModalView');
const SelectTaskGridView = require('./SelectTaskGridView');
const SelectTaskFilterView = require('./SelectTaskFilterView');
const PaginatorView = require('../../../pagination/paging/PaginatorView');

/**
 * @class SelectTaskModalView
 * @extends SelectResourceModalView
 *
 * @property {CustomFieldModel} model
 * @property {TasksCollection} collection
 * @property {Backbone.Marionette.Region} grid
 * @property {Backbone.Marionette.Region} filter
 */
const SelectTaskModalView = SelectResourceModalView.extend({

    template: require('./tpl/edit/SelectTaskModalView.hbs'),

    collectionEvents: {
        'change:selected': 'onTaskSelected'
    },

    onRender() {
        this.filter.close();
        this.grid.close();
        this.pagination.close();

        this.filter.show(this.getTaskFilter());
        this.grid.show(this.getTaskGrid());
        this.pagination.show(this.getPagination());

        const self = this;

        setTimeout(() => {
            self.updateModalHeight();
            self.collection.trigger('update:complete');
        }, 0);
    },

    getTaskGrid() {
        return new SelectTaskGridView({
            model: this.model,
            collection: this.collection
        });
    },

    getTaskFilter() {
        return new SelectTaskFilterView({
            model: this.collection.getFilterParams(),
            taskProps: this.options.taskProps,
            collection: this.collection
        });
    },

    getPagination() {
        return new PaginatorView({
            collection: this.collection,
            gridCnt: null
        });
    },

    onTaskSelected(model, isSelected) {
        if (!this.options.isMultiple && isSelected) {
            this.collection.where({ selected: true }).forEach(task => {
                if (task.get('id') !== model.get('id')) {
                    task.set('selected', false);
                }
            });
        }
    }
}, {
    CONTROLS_HEIGHT: 200
});

module.exports = SelectTaskModalView;
