/* eslint camelcase: 0 */
const error = require('../../../../error');
const CustomFieldView = require('../CustomFieldView');
const ResourceCustomFieldView = require('../ResourceCustomFieldView');
const SelectTaskModalView = require('./SelectTaskModalView');
const TasksCollection = require('../../../../collection/TasksCollection');
const TaskModel = require('../../../../model/TaskModel');

/**
 * @class TaskCustomFieldView
 * @extends ResourceCustomFieldView
 */
const TaskCustomFieldView = ResourceCustomFieldView.extend(/** @lends TaskCustomFieldView.prototype */{

    template: require('./tpl/edit/TaskCustomFieldView.hbs'),

    initialize() {
        CustomFieldView.prototype.initialize.apply(this, arguments);

        if (this.options.fieldViewMode === CustomFieldView.MODE.VIEW) {
            this.template = require('./tpl/view/TaskCustomFieldView.hbs');
        }
    },

    onSelect(evtObj) {
        evtObj.preventDefault();

        const self = this;
        const tasks = this.getTasksCollection();

        this.ui.loader.removeClass('hidden');

        tasks.update().done(() => {
            (new SelectTaskModalView({
                model: self.model,
                collection: tasks,
                taskProps: self.options.taskProps
            })).show();
        }).always(() => {
            self.ui.loader.addClass('hidden');
        }).fail(() => {
            error.message('Error during loading tasks');
        });
    },

    onDirectIdChange() {
        this.ui.replaceResourceTrigger.addClass('button_load');

        const self = this;
        const selectedId = this.ui.resourceIdInput.val();
        const taskToReplace = new TaskModel({ id: selectedId });

        taskToReplace
            .fetch({ reset: true })
            .done(() => {
                const descriptionToSet = {};
                const linksToSet = {};

                descriptionToSet[taskToReplace.get('id')] = taskToReplace.get('description');
                linksToSet[taskToReplace.get('id')] = taskToReplace.get('http');

                self.model.set({
                    value: taskToReplace.get('id'),
                    resource_description: descriptionToSet,
                    resource_links: linksToSet
                });
            })
            .fail(() => {
                error.message('Problem with fetching task #' + selectedId + '. Please check if ID is right', {
                    reload: false
                });
            })
            .always(() => {
                self.ui.replaceResourceTrigger.removeClass('button_load');
            });
    },

    getTasksCollection() {
        return new TasksCollection([], _.extend(
            { pageCapacity: 10 },
            this.mapContextToFilter()
        ));
    }
});

module.exports = TaskCustomFieldView;
