const TaskResourcesGridHeaderView = require('../../tasks/taskResourcesGrid/TaskResourcesGridHeaderView');
const SelectTaskResourcesGridBodyView = require('./SelectTaskResourcesGridBodyView');
const BasicCollection = require('../../../collection/BasicCollection');
const BasicGridView = require('../../tasks/basicGrid/BasicGridView');

/**
 * @class SelectTaskResourcesGridView
 * @extends BasicGridView
 * @property {ResourcesCollection} collection
 */
const SelectTaskResourcesGridView = BasicGridView.extend({

    options: _.extend({}, BasicGridView.prototype.options, {
        selectable: true,
        sortable: true,
        sortType: BasicCollection.SORT_TYPE.SERVER,

        bodyClass: SelectTaskResourcesGridBodyView,
        headerClass: TaskResourcesGridHeaderView
    }),

    getOptions() {
        return _.extend(
            {
                isModal: this.options.isModal,
                isMultiple: this.options.isMultiple
            },
            BasicGridView.prototype.getOptions.apply(this, arguments)
        );
    }
});

module.exports = SelectTaskResourcesGridView;
