const BasicGridBodyView = require('../../tasks/basicGrid/BasicGridBodyView');

/**
 * @class SelectTaskResourcesGridBodyView
 * @extends BasicGridBodyView
 */
const SelectTaskResourcesGridBodyView = BasicGridBodyView.extend({

    itemView: require('./SelectTaskResourcesRowView'),
    emptyView: require('../../tasks/taskResourcesGrid/TaskResourcesRowEmptyView'),
    itemViewOptions: {
        selectable: false
    },

    collectionEvents: _.extend({}, BasicGridBodyView.prototype.collectionEvents, {
        'change:selected': 'onResourceSelected'
    }),

    getItemViewOptions() {
        const opts = BasicGridBodyView.prototype.getItemViewOptions.apply(this, arguments);

        opts.isModal = this.options.isModal;

        return opts;
    },

    /**
     * Will prevent multiple resource selection when it is not allowed by custom field options
     * @param {TaskResourceModel} model
     * @param {Boolean} isSelected
     */
    onResourceSelected(model, isSelected) {
        if (!this.options.isMultiple && isSelected) {
            this.collection.where({ selected: true }).forEach(resource => {
                if (resource.get('id') !== model.get('id')) {
                    resource.set('selected', false);
                }
            });
        }
    }
});

module.exports = SelectTaskResourcesGridBodyView;
