const FilterModel = require('../../model/filter/FilterModel');
const GridLayout = require('../components/grid/GridLayout');
const TasksCollection = require('../../collection/TasksCollection');

/**
 * @class EnqueuedTasksGrid
 * @extends GridLayout
 *
 * @property {CoreApplication} model
 * @property {EnqueuedTasksCollection} collection
 */
const EnqueuedTasksGrid = GridLayout.extend({

    tasks: null,

    collectionEvents: {
        sync: 'onQueuedCollectionSync'
    },

    initialize() {
        /* eslint camelcase: 0 */

        GridLayout.prototype.initialize.apply(this, arguments);

        this.tasks = new TasksCollection([], {
            hidden: true,
            task_id: this.getQueuedTasksIds(),
            children: true
        });

        this.listenTo(this.tasks, 'sync', this.mapHostScore);
        this.tasks.update();
    },

    mapHostScore() {
        let task = null;
        let queueInfo = null;

        for (let q = 0; q < this.tasks.length; q++) {
            task = this.tasks.at(q);
            queueInfo = this.collection.at(q);

            if (task && queueInfo && _.isArray(queueInfo.get('clients'))) {
                task.set('hostScore', queueInfo.get('clients')[0]);
            }
        }
    },

    onQueuedCollectionSync() {
        this.tasks.setFilterParams(new FilterModel({
            hidden: true,
            task_id: this.getQueuedTasksIds(),
            children: true
        }));
    },

    getGrid() {
        const GridClass = this.options.gridClass;

        return new GridClass(_.extend(
            {},
            { collection: this.tasks },
            this.options.gridOptions
        ));
    },

    getQueuedTasksIds() {
        let ids = this.collection
            .map(queuedTask => {
                return queuedTask.get('id');
            })
            .join(',');

        if (!ids) {
            ids = '-1';
        }

        return ids;
    },

    onClose() {
        this.stopListening(this.tasks, 'sync');
    }
});

module.exports = EnqueuedTasksGrid;
