const BasicCollection = require('../../collection/BasicCollection');
const BasicGridView = require('../tasks/basicGrid/BasicGridView');

/**
 * @class QueuedTaskCompactGridView
 * @extends BasicGridView
 * @property {TasksCollection} collection
 */
const QueuedTaskCompactGridView = BasicGridView.extend({

    options: _.extend({}, BasicGridView.prototype.options, {
        selectable: true,
        sortable: true,
        editable: true,
        sortType: BasicCollection.SORT_TYPE.SERVER,

        bodyClass: require('./QueuedTaskCompactGridBodyView'),
        headerClass: require('./QueuedTaskCompactGridHeaderView')
    })
});

module.exports = QueuedTaskCompactGridView;
