const React = require('react');
const ReactDOM = require('react-dom');

const TaskCompactRowView = require('../tasks/tasksGridCompact/row/TaskCompactRowView');

const OwnerInfo = require('../../components/OwnerInfo');

const QueuedTaskCompactRowView = TaskCompactRowView.extend({

    template: require('./tpl/QueuedTaskCompactRowView.hbs'),

    ui: Object.assign(
        {},
        TaskCompactRowView.prototype.ui,
        {
            ownerInfo: '#owner-info'
        }
    ),

    onRender() {
        TaskCompactRowView.prototype.onRender.apply(this, arguments);

        if (this.ui.ownerInfo[0]) {
            ReactDOM.render(
                <OwnerInfo owner={this.model.get('owner')} namespace={'tasks'} slim/>,
                this.ui.ownerInfo[0]
            );
        }
    },

    serializeData() {
        const serialized = TaskCompactRowView.prototype.serializeData.apply(this, arguments);

        serialized.inqueue = this.serializeInQueue();

        return serialized;
    },

    serializeInQueue() {
        return moment().subtract(moment(this.model.get('time').updated)).format('HH:mm:ss');
    }
});

module.exports = QueuedTaskCompactRowView;
