const PopupMenuView = require('../components/PopupMenuView');

/**
 * @class AdminMenuView
 * @extends PopupMenuView
 *
 * @property {UserModel} model
 */
const AdminMenuView = PopupMenuView.extend({

    className: 'popup_menu_widget',

    template: require('./tpl/adminMenu.hbs'),

    ui: {
        cnt: '.link_head'
    },

    events: {
        mouseleave: 'hideMenu',
        'mouseover @ui.cnt': 'showMenu',
        'hover @ui.cnt': 'showMenu'
    },

    initialize() {},

    hideMenu() {
        this.$el.removeClass(this.options.activeClass);
    },

    showMenu() {
        this.$el.addClass(this.options.activeClass);
    },

    serializeData() {
        return {
            isAdmin: this.model.isAdmin()
        };
    }
});

module.exports = AdminMenuView;
