const AdminMenuView = require('./AdminMenuView');

/**
 * @class HeaderNavigation
 * @extends Marionette.Layout
 *
 * @property {Marionette.Region} adminMenu
 */
const HeaderNavigation = Marionette.Layout.extend({

    className: 'head__menu',

    template: require('./tpl/HeaderNavigation.hbs'),

    ui: {
        $navItems: '.c_link'
    },

    events: {
        'click @ui.$navItems': 'onNavItemClick'
    },

    onRender() {
        this.adminMenu.close();
        this.adminMenu.show(this.getAdminMenu());

        this.markAsActive();
    },

    getAdminMenu() {
        return new AdminMenuView({
            model: this.options.user
        });
    },

    markAsActive() {
        if (window.location.pathname === '/') {
            this.ui.$navItems.first().addClass('cur');
        } else {
            this.ui.$navItems.each((index, elt) => {
                const $td = $(elt);

                if (window.location.pathname.indexOf($td.data('path')) !== -1) {
                    $td.addClass('cur');
                }
            });
        }
    },

    onNavItemClick(evtObj) {
        const isMetaKey = evtObj.ctrlKey || evtObj.metaKey || evtObj.which === 2;
        const $clicked = $(evtObj.currentTarget);

        if (!isMetaKey && !$clicked.hasClass('cur')) {
            this.ui.$navItems.removeClass('cur');
            $clicked.addClass('cur');
        }
    }
});

module.exports = HeaderNavigation;
