/* eslint max-statements: [1, 12] */

const BasicSuggestView = require('../components/BasicSuggestView');
const OwnersSuggestGroupModel = require('../../model/suggest/filter/OwnersSuggestGroupModel');
const TaskTypeSuggestGroupModel = require('../../model/suggest/searchbox/TaskTypeSuggestGroupModel');
const SingleOwnerSuggestGroupModel = require('../../model/suggest/filter/SingleOwnerSuggestGroupModel');
const ResourceTypeSuggestGroupModel = require('../../model/suggest/searchbox/ResourceTypeSuggestGroupModel');
const TaskSuggestGroupModel = require('../../model/suggest/searchbox/TaskSuggestGroupModel');
const ResourceSuggestGroupModel = require('../../model/suggest/searchbox/ResourceSuggestGroupModel');
const SuggestGroupModelManager = require('../../model/suggest/SuggestGroupModelManager');
// eslint-disable-next-line no-unused-vars
const app = require('../../app');
const router = require('../../router');

/**
 * @class SearchBoxView
 * @extends BasicSuggestView
 *
 * @property {CoreApplication} model
 */
const SearchBoxView = BasicSuggestView.extend({

    className: 'head__left',

    template: require('./tpl/SearchBoxView.hbs'),

    options: {
        opened: false,
        openedClass: 'select_open',
        placeholder: '',
        defaultValue: '',
        selectedValueType: ''
    },

    ui: _.extend({}, BasicSuggestView.prototype.ui, {
        searchTrigger: '.app_trigger_search'
    }),

    events: _.extend({}, BasicSuggestView.prototype.events, {
        'click @ui.searchTrigger': 'focusOnSearchBox'
    }),

    initialize() {
        if (this.model.getProps()) {
            BasicSuggestView.prototype.initialize.apply(this, arguments);
        }

        this.listenTo(this, 'selected', this.runSearch);
    },

    setSuggestGroups() {
        const taskProps = this.model.getProps();
        const managedGroups = {
            task: new TaskSuggestGroupModel({}),
            resource: new ResourceSuggestGroupModel({})
        };

        new SuggestGroupModelManager({}, { groups: managedGroups }); // eslint-disable-line

        this.addManagedGroups(managedGroups);

        this.collection.add(new SingleOwnerSuggestGroupModel());

        this.collection.add(new OwnersSuggestGroupModel({}, {
            basicItemsSet: taskProps.groups.convertToList(),
            defaultFilter() {
                return false;
            }
        }));

        this.collection.add(new TaskTypeSuggestGroupModel({}, {
            basicItemsSet: taskProps.types.convertToList(),
            basicItemsSetApply: false,
            defaultFilter() {
                return false;
            }
        }));

        this.collection.add(new ResourceTypeSuggestGroupModel({}, {
            basicItemsSet: taskProps.resourceTypes.convertToList(),
            basicItemsSetApply: false,
            defaultFilter() {
                return false;
            }
        }));
    },

    addManagedGroups(managedGroups) {
        Object.keys(managedGroups).forEach(function (groupName) {
            this.collection.add(managedGroups[groupName]);
        }, this);
    },

    runSearch(valueToSearch) {
        router.navigate(this.getSearchURL(valueToSearch), {
            trigger: true
        });
    },

    getSearchURL(toMap) {
        /* eslint complexity: [1, 7] */
        /* eslint max-statements: [1, 15] */

        let targetURL = '';

        switch (toMap.type) {
            case 'OwnerSuggestGroupModel': {
                targetURL = ('/tasks/?order=-updated&created=7_days&owner=' + toMap.value);
                break;
            }
            case 'SingleOwnerSuggestGroupModel': {
                targetURL = ('/tasks/?order=-updated&created=7_days&author=' + toMap.value);
                break;
            }
            case 'TaskTypeSuggestGroupModel': {
                targetURL = ('/tasks/?order=-updated&created=7_days&type=' + toMap.value);
                break;
            }
            case 'TaskSuggestGroupModel': {
                targetURL = ('/task/' + toMap.value + '/view');
                break;
            }
            case 'ResourceSuggestGroupModel': {
                targetURL = ('/resource/' + toMap.value + '/view');
                break;
            }
            case 'ResourceTypeSuggestGroupModel': {
                targetURL = ('/resources/?order=-update&type=' + toMap.value);
                break;
            }
            default:
        }

        return targetURL;
    },

    focusOnSearchBox(evtObj) {
        evtObj.preventDefault();
        this.ui.input.focus();
    },

    onClose() {
        this.stopListening(this, 'selected');
    }
});

module.exports = SearchBoxView;
