const React = require('react');
const ReactDOM = require('react-dom');
const Provider = require('react-redux').Provider;
const store = require('../../store/initializedStore');

// eslint-disable-next-line no-unused-vars
const app = require('../../app');
const User = require('bemmy/blocks/user');
// eslint-disable-next-line no-unused-vars
const router = require('../../router');
const resources = require('../../resources');
const SearchBoxView = require('./SearchBoxView');
// eslint-disable-next-line no-unused-vars
const AdminMenuView = require('./AdminMenuView');
const MainNavigationView = require('./HeaderNavigation');
const SubNavigationView = require('../navigation/MainNavigationView');

const Alert = require('../../components/common/Alert');
const LinkToNewUI = require('../../components/LinkToNewUI');
const Promo = require('../../components/Promo');

/**
 * @class HeaderView
 * @extends Marionette.Layout
 *
 * @property {CoreApplication}   model
 * @property {Marionette.Region} user
 * @property {Marionette.Region} searchBox
 * @property {Marionette.Region} mainNavigation
 */
const HeaderView = Marionette.Layout.extend({

    template: require('./tpl/header.hbs'),

    className: 'head',

    events: {
        'click .link': 'onLink'
    },

    ui: {
        alerts: '#alerts',
        newInterface: '#btn-to-new-interface',
        promo: '#promo-to-new-interface'
    },

    onRender() {
        this.showUserControls();
        this.showSearchBox();

        if (this.ui.alerts[0]) {
            ReactDOM.render(
                <Provider store={store}>
                    <Alert />
                </Provider>,
                this.ui.alerts[0]
            );
        }

        if (this.ui.newInterface[0]) {
            ReactDOM.render(
                <LinkToNewUI />,
                this.ui.newInterface[0]
            );
        }

        if (this.ui.promo[0]) {
            ReactDOM.render(
                <Promo />,
                this.ui.promo[0]
            );
        }
    },

    showUserControls() {
        const self = this;

        resources.user({}, this.model).done(() => {
            const pageProps = self.model.get('pageProps');

            self.user.close();
            self.mainNavigation.close();

            self.user.show(self.getUserControl());
            self.mainNavigation.show(new MainNavigationView({ user: self.model.getUser() }));

            if (pageProps && pageProps.hasMenu) {
                self.subNavigation.close();
                self.subNavigation.show(self.getNavigation());
            }
        });
    },

    getNavigation() {
        return new SubNavigationView({
            model: this.model
        });
    },

    showSearchBox() {
        const self = this;

        resources.taskProps({}, this.model).done(() => {
            if (self.searchBox) {
                self.searchBox.close();
                self.searchBox.show(self.getSearchBox());
            }
        });
    },

    getSearchBox() {
        return new SearchBoxView({
            model: this.model
        });
    },

    getUserControl() {
        return new User({
            model: this.model.getUser()
        });
    }
});

module.exports = HeaderView;
