/* eslint max-params: [1, 7] */

const Handlebars = require('hbsfy/runtime');
const select = require('./tpl/select.hbs');

Handlebars.registerHelper(
    'createSelect',
    (placeholder, items, editable, defaultVal, className, emptyVal, width) => {
        const itemsToShow = [];

        items.forEach(elt => {
            const isStr = (typeof elt === 'string');

            itemsToShow.push({
                key: isStr ? elt : elt.key,
                label: isStr ? elt : elt.label,
                default: isStr ? (elt === defaultVal) : (elt.key === defaultVal)
            });
        });

        return new Handlebars.SafeString(select({
            placeholder,
            className,
            editable,
            items: itemsToShow,
            emptyVal,
            width
        }));
    }
);
