const Handlebars = require('hbsfy/runtime');
const taskSuggestItem = require('./tpl/taskSuggestItem.hbs');

Handlebars.registerHelper('createSuggestItem', (key, value, memberOf, attrs) => {
    /* eslint max-statements: [1, 12] */

    const item = require('./tpl/suggestItem.hbs');
    const itemData = {
        key,
        type: memberOf,
        value: '',
        high: false
    };

    switch (memberOf) {
        case 'SingleOwnerSuggestGroupModel': {
            itemData.value = [
                '<span style="color:red;">',
                value.substring(0, 1),
                '</span>',
                value.substring(1)
            ].join('');
            break;
        }
        case 'TaskSuggestGroupModel':
        case 'ResourceSuggestGroupModel': {
            itemData.key = attrs.id;
            itemData.high = true;
            itemData.value = taskSuggestItem({
                status: attrs.status.toLowerCase(),
                owner: attrs.owner,
                type: attrs.type,
                id: attrs.id
            });
            break;
        }
        default: {
            itemData.value = value;
            break;
        }
    }

    return new Handlebars.SafeString(item(itemData));
});
