const Handlebars = require('hbsfy/runtime');

Handlebars.registerHelper('domainLink', fullLink => {
    const matched = (/.+:\/\/([a-z0-9-]+)\..+/i).exec(fullLink);
    const domain = (matched ? matched[1] : '');

    return new Handlebars.SafeString('<a class="link" href="' + Handlebars.Utils.escapeExpression(fullLink) + '">' + domain + '</a>');
});
