const Handlebars = require('hbsfy/runtime');

Handlebars.registerHelper('formatRepeatInterval', repeat => {
    let stringified = 'NOT defined';

    if (repeat) {
        if (repeat.interval && parseInt(repeat.interval, 10)) {
            stringified = moment.duration(repeat.interval, 'seconds').humanize();
        }

        if (repeat.weekly) {
            stringified = (repeat.weekly.length === 7 ?
                'Every day' :
                repeat.weekly.map(dayNum => {
                    /* eslint complexity: [1, 8] */

                    switch (dayNum) {
                        case 0: { return 'Mon'; }
                        case 1: { return 'Tue'; }
                        case 2: { return 'Wen'; }
                        case 3: { return 'Thu'; }
                        case 4: { return 'Fri'; }
                        case 5: { return 'Sat'; }
                        case 6: { return 'Sun'; }
                        default: { return ''; }
                    }
                }).join(', ')
            );
        }
    }

    return stringified;
});
