const Handlebars = require('hbsfy/runtime');

Handlebars.registerHelper('getPrioritySwitcher', (priority, type) => {
    const values = type === 'class' ?
        ['USER', 'SERVICE', 'BACKGROUND'] :
        ['HIGH', 'NORMAL', 'LOW'];
    let switcher = '<div class="radiogroup app_priority_' + type + '">';

    for (let q = 0; q < values.length; q++) {
        switcher += [
            '<button class="button button_size_S button_mode_radio">',
            '<input type="radio" ' +
            '       name="priority_' + type + '" ' +
            '       value="' + values[q] + '"' +
            (priority[type] === values[q] ? ' checked="checked"' : '') + ' />',
            '<span class="button__label">' + values[q].substring(0, 1) + '</span>',
            '</button>'
        ].join('');
    }

    switcher += '</div>';

    return new Handlebars.SafeString(switcher);
});
