const Handlebars = require('hbsfy/runtime');
const getWeather = function (weather) {
    /* eslint max-statements: [1, 13] */
    /* eslint complexity: [1, 11] */

    let weatherKeyword = 'lightning';

    switch (parseInt(weather, 10)) {
        case 1:
        case 2: {
            weatherKeyword = 'lightning';
            break;
        }
        case 3:
        case 4: {
            weatherKeyword = 'rain';
            break;
        }
        case 5:
        case 6: {
            weatherKeyword = 'cloud';
            break;
        }
        case 7:
        case 8: {
            weatherKeyword = 'cloud-sun';
            break;
        }
        case 9:
        case 10: {
            weatherKeyword = 'sun';
            break;
        }
        default:
    }

    return weatherKeyword;
};

Handlebars.registerHelper('getWeather', getWeather);

module.exports = {
    getWeather
};
