const Handlebars = require('hbsfy/runtime');

Handlebars.registerHelper('humanizeDuration', time => {
    const hrs = Math.floor(time / 60 / 60);
    const mts = Math.floor((time - (hrs * 3600)) / 60);
    const sec = time - (hrs * 3600) - (mts * 60);

    return (((hrs ? hrs + 'h' : '') + (mts ? ' ' + mts + 'm' : '') + (sec ? ' ' + sec + 's' : '')) || '0s').trim();
});
