const Handlebars = require('hbsfy/runtime');
const sanitize = require('sanitize-html');
const opts = {
    allowedTags: sanitize.defaults.allowedTags.concat(['style', 'input', 'span']),
    allowedAttributes: Object.assign(
        {},
        sanitize.defaults.allowedAttributes,
        {
            input: ['name', 'value', 'checked', 'style', 'type'],
            td: ['colspan', 'rowspan'],
            th: ['colspan', 'rowspan'],
            '*': ['style', 'color', 'bgcolor', 'title', 'valign', 'class']
        }
    )
};

Handlebars.registerHelper('sanitize', htmlToProcess => {
    return new Handlebars.SafeString(sanitize(htmlToProcess, opts));
});
