const Handlebars = require('hbsfy/runtime');

Handlebars.registerHelper('splitID', (idToSplit, monoSpace) => {
    const id = String(idToSplit);
    let splitted = '';
    const basePartLength = 4;

    monoSpace = (typeof monoSpace === 'boolean' ? monoSpace : true);

    splitted = [
        '<span>',
        id.substring(0, id.length - basePartLength),
        '</span>',
        // ' ',
        id.substring(id.length - basePartLength)
    ].join('');

    if (monoSpace) {
        splitted = ('<span class="t__console white-space_no">' + splitted + '</span>');
    }

    return new Handlebars.SafeString(splitted);
});
