const Handlebars = require('hbsfy/runtime');
const singleUser = require('./tpl/singleUserLink.hbs');
const groupUser = require('./tpl/groupUserLink.hbs');

Handlebars.registerHelper('userLink', (login, urlPrefix, isDismissed) => {
    if (login === login.toUpperCase()) {
        return new Handlebars.SafeString(groupUser({
            login,
            first: login.substr(0, 1),
            second: login.substr(1),
            urlPrefix: (_.isString(urlPrefix) ? urlPrefix : '')
        }));
    }

    return new Handlebars.SafeString(singleUser({
        login,
        first: login.substr(0, 1),
        second: login.substr(1),
        urlPrefix: (_.isString(urlPrefix) ? urlPrefix : ''),
        isDismissed: (_.isBoolean(isDismissed) ? isDismissed : false)
    }));
});
