/* eslint max-len: [1, 130] */

const cookie = require('bemmy/src/blocks/component/cookie');
const app = require('../../app');
const notification = require('../../notification');
const Header = require('../header/header');
const ContentLayoutFactory = require('./content/ContentLayoutFactory');
const ApiInfoPanel = require('../../views/components/infoPanels/ApiInfoPanel');
const SandboxModeInfoPanel = require('../../views/components/infoPanels/SandboxModeInfoPanel');
const ServiceNotificationsMonitorView = require('../../views/serviceNotifications/monitor/ServiceNotificationsMonitorView');

/**
 * @class BasicLayout
 * @extends Backbone.Marionette.Layout
 *
 * @property {CoreApplication} model
 * @property {Marionette.Region} header
 * @property {Marionette.Region} content
 * @property {Marionette.Region} apiInfo
 * @property {Marionette.Region} modePanel
 * @property {Marionette.Region} serviceNotifications
 */
const BasicLayout = Marionette.Layout.extend({

    template: require('./tpl/BasicLayout.hbs'),

    options: {
        showHeader: true,
        showContent: true
    },

    /** REGIONS ARE DEFINED DIRECTLY IN THE TEMPLATE */

    onRender() {
        if (this.options.showHeader) {
            this.header.close();
            this.header.show(this.getHeader());
        }

        if (this.options.showContent) {
            this.showContent();
        }

        this.apiInfo.close();
        this.modePanel.close();
        this.serviceNotifications.close();

        this.apiInfo.show(this.getApiInfoPanel());
        this.modePanel.show(this.getModePanel());
        this.serviceNotifications.show(this.getServiceNotifications());

        this.showNotifications();
    },

    getHeader() {
        app.performance.header = (Math.round(window.performance.now() - app.performance.epoch)) / 1000;

        if (window.yaCounter28049724 && window.yaCounter28049724.reachGoal && window.location.host === 'sandbox.yandex-team.ru') {
            const params = {
                login: cookie.getYandexLogin(),
                internalRoute: app.performance.internalRoute,
                time: app.performance.header,
                origin: document.location.pathname + document.location.search
            };

            window.yaCounter28049724.reachGoal('PERFORMANCE_HEADER', params);
        }

        return new Header({
            model: this.model
        });
    },

    getServiceNotifications() {
        return new ServiceNotificationsMonitorView({});
    },

    getContent() {
        return ContentLayoutFactory.getLayout(this.model, this, (this.options.contentOptions || {}));
    },

    getFilter() {
        const pageProps = this.model.getPageProps();

        const view = pageProps && pageProps.controls;

        return view;
    },

    showFilter() {
        const View = this.getFilter();

        if (View) {
            const params = {
                model: this.model,
                collection: this.collection
            };

            this.filter.close();
            this.filter.show(new View(params));
        }
    },

    showContent() {
        this.content.close();
        this.content.show(this.getContent());
    },

    getApiInfoPanel() {
        return new ApiInfoPanel();
    },

    getModePanel() {
        return new SandboxModeInfoPanel();
    },

    showNotifications() {
        BasicLayout.showNotifications();
    },

    serializeData() {
        return {
            year: new Date().getFullYear()
        };
    }
}, {
    showNotifications() {
        const notificationData = app.getNotifications().shift();

        if (notificationData) {
            notification.message(notificationData.message, notificationData.options);
        }
    },

    hideNotifications() {
        notification.close();
    }
});

module.exports = BasicLayout;
