/**
 * @class ContentLayout
 * @extends Marionette.Layout
 *
 * @property {CoreApplication} model
 */
const ContentLayout = Marionette.Layout.extend({

    className: 'section section_slim',

    template: require('./tpl/ContentLayout.hbs'),

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onRender() {
        this.controls.close();
        this.content.close();

        this.controls.show(this.getControls());
        this.content.show(this.getContent());
    },

    getNavigation() {
        throw new Error('SANDBOX: each content layout should render «navigation» region');
    },

    getContent() {
        throw new Error('SANDBOX: each content layout should render «content» region');
    },

    getControls() {
        throw new Error('SANDBOX: each content layout should render «controls» region');
    }
});

module.exports = ContentLayout;

