const error = require('../../../error');

const ContentLayoutFactory = {

    layoutConfig: require('../../../application/config/layoutConfig'),

    /**
     * @param {CoreApplication} appResources
     */
    getLayout(appResources, parent, options) {
        const pageProps = appResources.getPageProps();
        const contentLayoutOptions = ContentLayoutFactory.getCreateOptions(appResources, parent, options);
        const Layout = pageProps.layout;

        if (Layout) {
            return new Layout(contentLayoutOptions);
        }
        error.showErrPage();
        throw new Error('SANDBOX: unknown type of the page');
    },

    getCreateOptions(resources, parent, options) {
        return _.extend({}, options, {
            model: resources,
            parent
        });
    }
};

module.exports = ContentLayoutFactory;
