// eslint-disable-next-line no-unused-vars
const app = require('../../../app');
const CreateResourceLayout = require('../../createResource/CreateResourceLayout');

/**
 * @class CreateResourceContentLayout
 *
 * @property {CoreApplication} model
 */
const CreateResourceContentLayout = Marionette.Layout.extend({

    className: 'section section_slim',

    template: require('./tpl/CreateResourceContentLayout.hbs'),

    onRender() {
        this.content.close();
        this.content.show(this.getContent());
    },

    getContent() {
        return new CreateResourceLayout({
            types: this.model.get('types'),
            user: this.model.get('user')
        });
    }
});

module.exports = CreateResourceContentLayout;
