/* eslint max-len: [1, 130] */
const CreateSchedulerLayout = require('../../createScheduler/CreateSchedulerLayout');
const CreateTaskContentLayout = require('./CreateTaskContentLayout');
const CreateSchedulerControlSectionLayout = require('../../controlSection/createScheduler/CreateSchedulerControlSectionLayout');

/**
 * @class CreateSchedulerContentLayout
 * @extends CreateTaskContentLayout
 *
 * @property {CoreApplication} model
 */
const CreateSchedulerContentLayout = CreateTaskContentLayout.extend({

    template: require('./tpl/CreateTaskContentLayout.hbs'),

    getControls() {
        return new CreateSchedulerControlSectionLayout({
            model: this.model.getScheduler(),
            taskTypes: this.model.getProps().types
        });
    },

    getContent() {
        return new CreateSchedulerLayout({
            taskProps: this.model.getProps(),
            model: this.model.getScheduler(),
            user: this.model.getUser()
        });
    }
});

module.exports = CreateSchedulerContentLayout;
