// eslint-disable-next-line no-unused-vars
const app = require('../../../app');
const ContentLayout = require('./ContentLayout');
// eslint-disable-next-line no-unused-vars
const SingleTaskSecNavigation = require('../../navigation/secnavigation/SingleTaskSecNavigation');
const CreateTaskControlSection = require('../../controlSection/createTask/CreateTaskControlSectionLayout');
const CreateTaskLayout = require('../../createTask/CreateTaskLayout');

/**
 * @class CreateTaskContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 */
const CreateTaskContentLayout = ContentLayout.extend({

    template: require('./tpl/CreateTaskContentLayout.hbs'),

    getControls() {
        return new CreateTaskControlSection({
            model: this.model.getTask(),
            taskTypes: this.model.getProps().types
        });
    },

    getContent() {
        return new CreateTaskLayout({
            taskProps: this.model.getProps(),
            model: this.model.getTask(),
            user: this.model.getUser()
        });
    }
});

module.exports = CreateTaskContentLayout;
