const ContentLayout = require('./ContentLayout');
const DBStateContent = require('../../admin/dbState/DBStateContent');

/**
 * @class DBStateContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication}   model
 * @property {Marionette.Region} content
 */
const DBStateContentLayout = ContentLayout.extend({

    template: require('./tpl/DBStateContentLayout.hbs'),

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onRender() {
        this.content.close();
        this.content.show(this.getContent());
    },

    getContent() {
        return new DBStateContent({
            collection: this.model.getShards()
        });
    }
});

module.exports = DBStateContentLayout;
