const router = require('../../../router');
const resources = require('../../../resources');
// eslint-disable-next-line no-unused-vars
const GridLayout = require('./../../components/grid/GridLayout');
const AutocompleteView = require('../../controlSection/filter/selects/autocomplete/AutocompleteView');
const ContentLayout = require('./ContentLayout');
const EnqueuedTasksGrid = require('../../enqueuedTasks/EnqueuedTasksGrid');
const QueuedTaskCompactGridView = require('../../enqueuedTasks/QueuedTaskCompactGridView');

/**
 * @class HostQueueContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 * @property {Marionette.Region} content
 */
const HostQueueContentLayout = ContentLayout.extend({

    className: 'section section_slim',

    template: require('./tpl/HostQueueContentLayout.hbs'),

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onRender() {
        const self = this;

        this.content.close();
        this.content.show(this.getContent());

        resources.clients().done(clients => {
            self.hostSelector.close();
            self.hostSelector.show(self.getHostSelector(clients.get('hosts')));
        });
    },

    getContent() {
        return new EnqueuedTasksGrid({
            model: this.model,
            collection: this.model.get('enqueuedTasks'),
            gridClass: QueuedTaskCompactGridView,
            gridOptions: {
                sortable: false,
                selectable: false,
                autoUpdateEnabled: Boolean(this.model.getPageProps().isAutoupdateEnabled)
            }
        });
    },

    getHostSelector(hosts) {
        const filterModel = this.model.get('enqueuedTasks').getFilterParams();

        this.listenTo(filterModel, 'change', function () {
            this.model.get('enqueuedTasks').setFilterParams(filterModel.clone());
            router.navigate(('/host/' + filterModel.get('client') + '/queue'), { trigger: false });
        });

        return new AutocompleteView({
            lazy: 300,
            model: filterModel,
            items: hosts,
            value: filterModel.serializeAsQuery().client,
            placeHolder: 'Client',
            showAnyItem: true,
            modelTargetKey: 'client',
            selectClassName: 'app_filter_host'
        });
    },

    serializeData() {
        return this.model.get('enqueuedTasks').getFilterParams().serializeAsQuery();
    },

    onClose() {
        this.stopListening(this.model.get('enqueuedTasks').getFilterParams());
    }
});

module.exports = HostQueueContentLayout;
