const React = require('react');
const ReactDOM = require('react-dom');
const Provider = require('react-redux').Provider;
const store = require('../../../store/initializedStore');

const GroupsManager = require('../../../components/GroupsManager');

/**
 * @class AdminMainNavigationView
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 */
const ManageGroupsContentLayout = Marionette.Layout.extend({
    className: 'section section_slim',

    template: require('./tpl/ManageGroupsContentLayout.hbs'),

    ui: {
        region: '.manage-groups-content'
    },

    modelEvents: {
        'change:pageProps'() {
            this.trigger('content:replaced');
        }
    },

    onRender() {
        this._renderWrapperOfComponents();
    },

    _renderWrapperOfComponents() {
        if (this.ui.region[0]) {
            ReactDOM.render(
                <Provider store={store}>
                    <GroupsManager
                        model={this.model}
                        pageProps={this.model.get('pageProps')}
                        />
                </Provider>,
                this.ui.region[0]
            );
        }
    },

    destroyReactView() {
        if (this.content && this.content.$el) {
            ReactDOM.unmountComponentAtNode(this.content.$el[0]);
        }
    },

    close() {
        this.destroyReactView();
        this.remove();

        Marionette.Layout.prototype.close.call(this);
        Backbone.View.prototype.remove.call(this);

        return false;
    }
});

module.exports = ManageGroupsContentLayout;
