/* eslint no-console: 0 */

const React = require('react');
const ReactDOM = require('react-dom');
const Provider = require('react-redux').Provider;
const store = require('../../../store/initializedStore');

const SemaphoresManager = require('../../../components/SemaphoresManager');

/**
 * @class ManageSemaphoresContentLayout
 * @extends Marionette.Layout
 *
 * @property {CoreApplication} model
 */
const ManageSemaphoresContentLayout = Marionette.Layout.extend({
    className: 'section section_slim',

    template: require('./tpl/ManageSemaphoresContentLayout.hbs'),

    ui: {
        region: '.manage-semaphores-content'
    },

    modelEvents: {
        'change:pageProps'() {
            this.trigger('content:replaced');
        }
    },

    onRender() {
        this._renderWrapperOfComponents();
    },

    _renderWrapperOfComponents() {
        if (this.ui.region[0]) {
            ReactDOM.render(
                <Provider store={store}>
                    <SemaphoresManager
                        model={this.model}
                        pageProps={this.model.get('pageProps')}
                        />
                </Provider>,
                this.ui.region[0]
            );
        }
    },

    destroyReactView() {
        if (this.content && this.content.$el) {
            ReactDOM.unmountComponentAtNode(this.content.$el[0]);
        }
    },

    close() {
        this.destroyReactView();
        this.remove();

        Marionette.Layout.prototype.close.call(this);
        Backbone.View.prototype.remove.call(this);

        return false;
    }
});

module.exports = ManageSemaphoresContentLayout;
