const GridLayout = require('./../../components/grid/GridLayout');
const ContentLayout = require('./ContentLayout');
const TaskTypesFilter = require('../../taskTypes/TaskTypesFilter');
const TaskTypeFilterModel = require('../../../model/filter/TaskTypeFilterModel');
const AdminMainNavigationView = require('../../navigation/admin/AdminMainNavigationView');
const ManagedTaskTypesCollection = require('../../../collection/ManagedTaskTypesCollection');

/**
 * @class ManageTaskTypesContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 */
const ManageTaskTypesContentLayout = ContentLayout.extend({

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    initialize() {
        this.rawTypes = new Backbone.VirtualCollection(this.model.getProps().types);

        this.taskTypes = new ManagedTaskTypesCollection([], {
            sourceCollection: this.rawTypes,
            total: this.rawTypes.length
        });

        this.taskTypes.setPage(1);
    },

    getNavigation() {
        return new AdminMainNavigationView({
            model: this.model
        });
    },

    getControls() {
        return new TaskTypesFilter({
            collection: this.taskTypes,
            props: this.model.get('props'),
            model: new TaskTypeFilterModel()
        });
    },

    getContent() {
        return new GridLayout({
            model: this.model,
            collection: this.taskTypes,
            gridClass: require('../../admin/manageTaskTypes/TaskTypeGridView'),
            gridOptions: {
                model: this.model
            }
        });
    }
});

module.exports = ManageTaskTypesContentLayout;
