const GridLayout = require('./../../components/grid/GridLayout');
const ContentLayout = require('./ContentLayout');
const ManageVaultsControls = require('../../controlSection/adminControls/ManageVaultsControls');
const AdminMainNavigationView = require('../../navigation/admin/AdminMainNavigationView');

/**
 * @class ManageVaultsContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 */
const ManageVaultsContentLayout = ContentLayout.extend({

    getNavigation() {
        return new AdminMainNavigationView({
            model: this.model
        });
    },

    getControls() {
        return new ManageVaultsControls({
            collection: this.model.getVaults(),
            model: this.model
        });
    },

    getContent() {
        return new GridLayout({
            model: this.model,
            collection: this.model.getVaults(),
            gridClass: require('../../admin/manageVault/VaultsGridView'),
            gridOptions: {
                model: this.model
            },
            paginationClass: null
        });
    }
});

module.exports = ManageVaultsContentLayout;
