const ContentLayout = require('./ContentLayout');
const OAuthContent = require('../../admin/oauth/OAuthContent');

/**
 * @class OAuthContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication}   model
 * @property {Marionette.Region} content
 */
const OAuthContentLayout = ContentLayout.extend({

    template: require('./tpl/OAuthContentLayout.hbs'),

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onRender() {
        this.content.close();
        this.content.show(this.getContent());
    },

    getContent() {
        return new OAuthContent({
            model: this.model
        });
    }
});

module.exports = OAuthContentLayout;
