import React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import store from '../../../store/initializedStore';

import Preferences from '../../../components/PreferencesWrapper';

const PreferencesPageLayout = Marionette.Layout.extend({
    template: require('./tpl/PreferencesPageLayout.hbs'),

    ui: {
        preferences: '#preferences'
    },

    onRender() {
        if (this.ui.preferences[0]) {
            ReactDOM.render(
                <Provider store={store}>
                    <Preferences/>
                </Provider>,
                this.ui.preferences[0]
            );
        }
    }
});

module.exports = PreferencesPageLayout;
