const GridLayout = require('./../../components/grid/GridLayout');
const ContentLayout = require('./ContentLayout');
const ReleasesGridView = require('../../releases/releasesGrid/ReleaseGridView');

/**
 * @class ReleaseListContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 * @property {Marionette.Region} content
 * @property {Marionette.Region} controls
 */
const ReleaseListContentLayout = ContentLayout.extend({
    onRender() {
        this.content.close();
        this.content.show(this.getContent());
    },

    getContent() {
        return new GridLayout({
            model: this.model,
            collection: this.model.getReleases(),
            gridClass: ReleasesGridView,
            gridOptions: {
                autoUpdateEnabled: Boolean(this.model.getPageProps().isAutoupdateEnabled)
            }
        });
    }
});

module.exports = ReleaseListContentLayout;
