const ContentLayout = require('./ContentLayout');
const GridLayout = require('./../../components/grid/GridLayout');
const TaskResourcesGridView = require('../../tasks/taskResourcesGrid/TaskResourcesGridView');

/**
 * @class ResourceListContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 */
const ResourceListContentLayout = ContentLayout.extend({
    onRender() {
        this.content.close();
        this.content.show(this.getContent());
    },

    getContent() {
        return new GridLayout({
            model: this.model,
            collection: this.model.getResources(),
            gridClass: TaskResourcesGridView,
            gridOptions: {
                selectable: true,
                autoUpdateEnabled: Boolean(this.model.getPageProps().isAutoupdateEnabled)
            }
        });
    }
});

module.exports = ResourceListContentLayout;
